package com.qboxus.tictic.adapters

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.interfaces.AdapterClickListener
import com.qboxus.tictic.models.HomeModel
import com.qboxus.tictic.simpleclasses.Functions.frescoImageLoad
import com.qboxus.tictic.simpleclasses.Functions.getSuffix
import com.qboxus.tictic.simpleclasses.Functions.isStringHasValue
import com.qboxus.tictic.simpleclasses.Functions.printLog
import com.facebook.drawee.view.SimpleDraweeView

/**
 * Created by qboxus on 3/20/2018.
 */
class MyVideosAdapter(
    var context: Context,
    private val dataList: MutableList<HomeModel>,
    var whereFrom: String,
    var adapterClickListener: AdapterClickListener
) : RecyclerView.Adapter<MyVideosAdapter.CustomViewHolder>() {
    override fun onCreateViewHolder(viewGroup: ViewGroup, viewtype: Int): CustomViewHolder {
        val view = LayoutInflater.from(viewGroup.context)
            .inflate(R.layout.item_myvideo_layout, viewGroup, false)
        return CustomViewHolder(view)
    }

    override fun getItemCount(): Int {
        return dataList.size
    }

    override fun onBindViewHolder(holder: CustomViewHolder, i: Int) {
        val item = dataList[i]
        try {
            if (Constants.IS_SHOW_GIF) {
                holder.thumbImage.controller =
                    frescoImageLoad(item.getGif(), holder.thumbImage, true)
            } else if (isStringHasValue(item.getThum())) {
                holder.thumbImage.controller =
                    frescoImageLoad(item.getThum(), holder.thumbImage, false)
            }
        } catch (e: Exception) {
            printLog(Constants.tag, e.toString())
        }
        if (whereFrom == "myProfile") {
            if (item.pin == "1") {
                holder.tabPinned.visibility = View.VISIBLE
            } else {
                holder.tabPinned.visibility = View.GONE
            }
        } else {
            holder.tabPinned.visibility = View.GONE
        }
        holder.viewTxt.text = item.views
        holder.viewTxt.text = getSuffix(item.views)
        holder.bind(i, item, adapterClickListener)
    }

    inner class CustomViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        var thumbImage: SimpleDraweeView
        var viewTxt: TextView
        var tabPinned: LinearLayout

        init {
            tabPinned = view.findViewById(R.id.tabPinned)
            thumbImage = view.findViewById(R.id.thumb_image)
            viewTxt = view.findViewById(R.id.view_txt)
        }

        fun bind(position: Int, item: HomeModel?, listener: AdapterClickListener) {
            itemView.setOnClickListener { v: View? -> listener.onItemClick(v, position, item) }
        }
    }
}